#version 330
#extension GL_EXT_gpu_shader4 : enable
//signal fieldMod01.fsh  by  kig 

//https://www.shadertoy.com/view/lll3DB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = vec2(iResolution.x/iResolution.y,1.0) * (-1.0 + 2.0*gl_FragCoord.xy / iResolution.xy);
   
    vec2 ouv = uv;
    
    float a = sin(iTime*0.5)*0.2;
    float ca = cos(a);
    float sa = sin(a);
    
    uv *= mat2(ca, sa, -sa, ca);

    float df = abs(uv.y+1.3)*uv.x*uv.x;
    uv *= 3.0+1.9*df;
    uv.x += iTime*2.0;
    uv.y += iTime*2.0;
    
    uv *= 2.0;

    uv.x = pow(sin(uv.x+iTime*2.0) * cos(uv.y*3.0) * cos(uv.x*3.0+1.0), 4.0);
    uv.y = abs(sin(uv.y*16.0) * cos(uv.x*12.0) * sin(uv.y*1.0+3.14159*0.5));

    uv = pow(uv, vec2(1.0, 4.0));
    
	gl_FragColor = (1.0-pow(0.5*length(ouv), 3.0)) * vec4(uv.x+uv.x+0.1, 0.05+uv.y+uv.x, 0.25+uv.y, 1.0);
}